/*
 * QSeisPageRegistry.hpp
 *
 *  Created on: Mar 14, 2011
 *      Author: landvogt
 */


#ifndef QSEISPAGEREGISTRY_HPP
#define QSEISPAGEREGISTRY_HPP

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtCore/QObject>

#include "CodePatterns/Registry.hpp"
#include "CodePatterns/Singleton.hpp"

/**
 * \class QSeisPageRegistry
 *
 * This class acts as a registry for all QSeisPlotPage
 * objects. This registry does not allow to (un)register
 * instances. Instead it creates a new instance if
 * getByName() with a non-existing name is called.
 *
 * The registry also passes the add/update/remove signals
 * to the PlotPage with the correct dataType string.
 *
 * On creating and destroying of an instance the
 * pageCreated/pageDeleted signal is emitted to keep the GUI
 * updated.
 **/

class QSeisPlotPage;

class QSeisPageRegistry : public QObject, public Registry<QSeisPlotPage>, public Singleton<QSeisPageRegistry>
{
    Q_OBJECT

friend class Singleton<QSeisPageRegistry>;

public:
    QSeisPlotPage *getByName(const std::string name);
    void deleteByName(const std::string name);
    void cleanup();

public slots:
    void addCurve(std::string name, QString dataType);
    void removeCurve(std::string name, QString dataType);
    void updateCurve(std::string name, QString dataType);
    void resetPlotView(QString dataType);

private:
    QSeisPageRegistry();
    ~QSeisPageRegistry();
    void registerInstance(QSeisPlotPage *instance);
    void unregisterInstance(QSeisPlotPage *instance);

signals:
    void pageCreated(QWidget *page, QString name);
    void pageDeleted(QString name);
};

#endif // QSEISPAGEREGISTRY_HPP
