/*
 * QSeisCurveRegistry.hpp
 *
 *  Created on: Jan 30, 2011
 *      Author: landvogt
 */

#ifndef QSEISCURVEREGISTRY_HPP
#define QSEISCURVEREGISTRY_HPP

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtCore/QObject>
#include "CodePatterns/Registry.hpp"
#include "CodePatterns/Singleton.hpp"

/**
 * \class QSeisCurveRegistry
 *
 * This class acts as a registry for all
 * currently available QSeisPlotCurves.
 *
 * The (un)registerInstance functions where
 * reimplemented to include the curveAdded/
 * Changed/Removed signals.
 * The QSeisPageRegistry relays on this
 * signals to maintain the existing list of
 * available curves.
 *
 * The resetRegistry() function is basically
 * the normal Registry::cleanup() function,
 * it only emits additionally the curveRemoved()
 * signal for every curve to keep the
 * PageRegistry on track.
 **/

class QSeisPlotCurve;

class QSeisCurveRegistry : public QObject, public Registry<QSeisPlotCurve>, public Singleton<QSeisCurveRegistry>
{
    Q_OBJECT

    friend class Singleton<QSeisCurveRegistry>;

public:
    void registerInstance(QSeisPlotCurve *instance);
    void unregisterInstance(QSeisPlotCurve *instance);
    void resetRegistry();

private:
    QSeisCurveRegistry();
    ~QSeisCurveRegistry();

signals:
    void curveAdded(std::string name, QString type);
    void curveChanged(std::string name, QString type);
    void curveRemoved(std::string name, QString type);
};

#endif // QSEISCURVEREGISTRY_HPP
