/*
 * GLMoleculeObject_molecule.hpp
 *
 *  Created on: Mar 30, 2012
 *      Author: ankele
 */

#ifndef GLMOLECULEOBJECT_MOLECULE_HPP_
#define GLMOLECULEOBJECT_MOLECULE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include "CodePatterns/Observer/Observer.hpp"

#include "GLMoleculeObject_bond.hpp"

class atom;
class bond;
class GLMoleculeObject_atom;
class GLWorldScene;
class molecule;

class GLMoleculeObject_molecule : public GLMoleculeObject, public Observer
{
  Q_OBJECT
public:
  GLMoleculeObject_molecule(QObject *parent, const molecule *molref);
  GLMoleculeObject_molecule(QGLSceneNode *mesh[], QObject *parent, const molecule *molref);
  virtual ~GLMoleculeObject_molecule();

  void updateBoundingBox();

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

  void initialize(QGLView *view, QGLPainter *painter);
  void draw(QGLPainter *painter, const QVector4D &cameraPlane);

  typedef std::pair< atomId_t, atomId_t> BondIds;
  friend std::ostream &operator<<(std::ostream &ost, const BondIds &t);

  static BondIds getBondIds(
      const bond::ptr _bond,
      const enum GLMoleculeObject_bond::SideOfBond side);

  void selected(const bool _isSelected)
  { isSelected = _isSelected; }

signals:
  void changed();
  void changeOccured();
  void hoverChanged(const atom*);
  void atomClicked(atomId_t no);
  void changeAtomId(GLMoleculeObject_atom *, int, int);

private slots:
  //!> grant GLWorldScene access to private slots
  friend class GLWorldScene;

  void atomInserted(const atomicNumber_t _id);
  void atomRemoved(const atomicNumber_t _id);
  void bondInserted(const bond::ptr _bond, const GLMoleculeObject_bond::SideOfBond side);
  void bondRemoved(const atomId_t leftnr, const atomId_t rightnr);
  void hoverChangedSignalled(GLMoleculeObject *ob);

  void setVisible(bool value);

private:
  void init();
  void reinit();

  void addAtomBonds(
      const bond::ptr &_bond,
      const GLMoleculeObject_bond::SideOfBond _side
      );
  void addAtomBonds(const atom *_atom);

  //!> states whether selection box is additionally drawn or not
  bool isSelected;

  //!> whether we are signed on to the associated molecule
  bool isSignedOn;

  const molecule *_molecule;

  typedef std::map< atomId_t, GLMoleculeObject_atom* > AtomNodeMap;
  typedef std::map< BondIds , GLMoleculeObject_bond* > BondNodeMap;
  AtomNodeMap AtomsinSceneMap;
  BondNodeMap BondsinSceneMap;

  const atom *hoverAtom;
};

std::ostream &operator<<(std::ostream &ost, const GLMoleculeObject_molecule::BondIds &t);


#endif /* GLMOLECULEOBJECT_MOLECULE_HPP_ */
