/*
 * ChangeTracker.hpp
 *
 *  Created on: Mar 1, 2010
 *      Author: metzler
 */

#ifndef CHANGETRACKER_HPP_
#define CHANGETRACKER_HPP_

#include "Patterns/Observer.hpp"
#include "World.hpp"

using namespace std;

/**
 * Observes the world and notifies subscribers via saveStatus if there are
 * changes to it.
 */
class ChangeTracker : public Singleton<ChangeTracker>, public Observable {
  friend class Singleton<ChangeTracker>;
public:
  void saveStatus();
  static ChangeTracker* get();
  static void destroy();

protected:
  void update(Observable *publisher);
  bool hasChanged();

private:
  bool isConsistent;
  static ChangeTracker* instance;

  // private constructor and destructor due to singleton
  ChangeTracker();
  ~ChangeTracker();
};

#endif /* CHANGETRACKER_HPP_ */
