/*
 * HelpAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/HelpAction.hpp"
#include "CommandLineParser.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char CommandLineHelpAction::NAME[] = "help";

CommandLineHelpAction::CommandLineHelpAction() :
  Action(NAME)
{}

CommandLineHelpAction::~CommandLineHelpAction()
{}

Dialog* CommandLineHelpAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  ostringstream usage;
  usage << CommandLineParser::getInstance().visible << endl;
  dialog->queryEmpty(NAME, usage.str());

  return dialog;
}

Action::state_ptr CommandLineHelpAction::performCall() {
  return Action::success;
}

Action::state_ptr CommandLineHelpAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr CommandLineHelpAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool CommandLineHelpAction::canUndo() {
  return true;
}

bool CommandLineHelpAction::shouldUndo() {
  return true;
}

const string CommandLineHelpAction::getName() {
  return NAME;
}
