/*
 * VectorInterface.hpp
 *
 *  Created on: Jul 29, 2010
 *      Author: heber
 */

#ifndef VECTORINTERFACE_HPP_
#define VECTORINTERFACE_HPP_

#include <cstring>
#include <iostream>

class Vector;

/** Contains all functions of the class Vector as virtual definitions, to give any
 * class derived from it the interface of a Vector, i.e. Vector-like abilities
 * (i.e. the scaffold design pattern).
 */
class VectorInterface  {
public:

  // Accessors ussually come in pairs... and sometimes even more than that
  virtual const double& operator[](size_t i) const = 0;
  virtual const double& at(size_t i) const = 0;
  virtual void set(size_t i, const double value) = 0;
  virtual const Vector& getPosition() const = 0;

  // Assignment operator
  virtual void setPosition(const Vector& _vector) = 0;

  // operators for mathematical operations
  virtual const VectorInterface& operator+=(const Vector& b) = 0;
  virtual const VectorInterface& operator-=(const Vector& b) = 0;
  virtual Vector const operator+(const Vector& b) const = 0;
  virtual Vector const operator-(const Vector& b) const = 0;

  virtual void Zero() = 0;
  virtual void One(const double one) = 0;
  virtual void LinearCombinationOfVectors(const Vector &x1, const Vector &x2, const Vector &x3, const double * const factors) = 0;

  virtual double distance(const Vector &point) const = 0;
  virtual double DistanceSquared(const Vector &y) const = 0;
  virtual double distance(const VectorInterface &_atom) const = 0;
  virtual double DistanceSquared(const VectorInterface &_atom) const = 0;

  virtual void ScaleAll(const double *factor) = 0;
  virtual void ScaleAll(const Vector &factor) = 0;
  virtual void Scale(const double factor) = 0;

  virtual std::ostream & operator << (std::ostream &ost) const = 0;

protected:
  /** Constructor and destructor are protected as VectorInterface should never
   * be instantiated by itself but only as a derived class.
   */
  VectorInterface();
  ~VectorInterface();
};

#endif /* VECTORINTERFACE_HPP_ */
