/*
 * CommandLineWindow.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include <boost/bind.hpp>

#include "CommandLineUI/CommandLineWindow.hpp"
#include "CommandLineUI/CommandLineStatusIndicator.hpp"

#include "Actions/Action.hpp"
#include "Actions/MapOfActions.hpp"
#include "Actions/ActionRegistry.hpp"

#include "CommandLineParser.hpp"

#include <iostream>

using namespace std;

// TODO: see what code can be moved to a base class for Graphic and CommandLine Windows
CommandLineWindow::CommandLineWindow()
{
  // create and register all command line callable actions
  MapOfActions::getInstance().populateActions();

  // Add status indicators etc...
  statusIndicator = new CommandLineStatusIndicator();
}

CommandLineWindow::~CommandLineWindow()
{
  delete statusIndicator;
}

void CommandLineWindow::display() {
  //cout << ActionRegistry::getInstance();

  // go through all possible actions
  for (std::list<std::string>::iterator CommandRunner = CommandLineParser::getInstance().SequenceOfActions.begin(); CommandRunner != CommandLineParser::getInstance().SequenceOfActions.end(); ++CommandRunner) {
    cout << "Checking presence of " << *CommandRunner << ": ";
    if (ActionRegistry::getInstance().isActionPresentByName(*CommandRunner)) {
      cout << "calling " << *CommandRunner << endl;
      ActionRegistry::getInstance().getActionByName(*CommandRunner)->call();
    } else {
      cout << "absent." << endl;
    }
  }
}

