/*
 * PotentialSubgraph.hpp
 *
 *  Created on: Oct 3, 2016
 *      Author: heber
 */


#ifndef POTENTIALS_POTENTIALSUBGRAPH_HPP_
#define POTENTIALS_POTENTIALSUBGRAPH_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

#include "../../FunctionApproximation/Subgraph/SubgraphEdge.hpp"

/** This class contains the specific definition of a subgraph that a specific
 * empirical potential models. Note that the graph is undirected.
 */
class PotentialSubgraph
{
public:

  //!> typedef for vector of edges
  typedef std::vector<SubgraphEdge> edges_t;

  /** Cstor of class PotentialSubgraph.
   *
   * \param _edges list of edges
   */
  PotentialSubgraph(const edges_t &_edges) :
    edges(_edges)
  {}

  /** Adds an edge to the subgraph.
   *
   *\param _edge edge to add
   */
  void add_edge(const SubgraphEdge &_edge)
  { edges.push_back(_edge); }

  /** Const getter for the edge set of the subgraph.
   *
   */
  const edges_t & getEdges() const
  { return edges; }

private:
  edges_t edges;
};


#endif /* POTENTIALS_POTENTIALSUBGRAPH_HPP_ */
