/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TextUIFactory.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/TextUI/TextUIFactory.hpp"
#include "UIElements/TextUI/TextWindow.hpp"
#include "UIElements/TextUI/TextDialog.hpp"

TextUIFactory::TextUIFactory()
{}

TextUIFactory::~TextUIFactory()
{}


Dialog* TextUIFactory::makeDialog(const std::string &_title) {
  return new TextDialog(_title);
}

MainWindow* TextUIFactory::makeMainWindow() {
  MainWindow* const mainwindow = new TextWindow();
  UIFactory::doneInitializing = true;
  return mainwindow;
}

TextUIFactory::description::description() :
    UIFactory::factoryDescription("Text")
{}

TextUIFactory::description::~description()
{}

UIFactory* TextUIFactory::description::makeFactory(){
  return new TextUIFactory();
}

