/*
 * UIFactory.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */


#include <cassert>
#include "UIElements/UIFactory.hpp"

// all factories that can be used:
#include "UIElements/TextUIFactory.hpp"
#ifdef USE_GUI_QT
#include "UIElements/QT4/QTUIFactory.hpp"
#endif

UIFactory *UIFactory::theFactory = 0;

UIFactory::UIFactory()
{
  // TODO Auto-generated constructor stub

}

UIFactory::~UIFactory()
{
  // TODO Auto-generated destructor stub
}

void UIFactory::makeUserInterface(InterfaceTypes type) {
  assert(theFactory == 0 && "makeUserInterface should only be called once");
  switch(type) {
    case Text :
      theFactory = new TextUIFactory();
      break;
#ifdef USE_GUI_QT
    case QT4 :
      theFactory = new QTUIFactory();
      break;
#endif
    default:
      assert(0 && "No such Factory in stock");
      break;
  }
}

UIFactory* UIFactory::get(){
  assert(theFactory != 0 && "No UserInterface created prior to factory access");
  return theFactory;
}


void UIFactory::purgeInstance(){
  if(theFactory) {
    delete theFactory;
    theFactory = 0;
  }
}
