/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ParserPdbUnitTest.cpp
 *
 *  Created on: Mar 3, 2010
 *      Author: metzler
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ParserPdbUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Parser/PdbParser.hpp"
#include "World.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "periodentafel.hpp"
#include "CodePatterns/Log.hpp"
#include "Descriptors/AtomTypeDescriptor.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace std;

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ParserPdbUnitTest );

//----|----*|---||--*||---|***|-------|-------|-------|-----|---------------|-|-
//000000011111111112222222222333333333344444444445555555555666666666677777777778
//345678901234567890123456789012345678901234567890123456789012345678901234567890
static string waterPdb = "\
REMARK  This is a test water molecule as written by TREMOLO.\n\
ATOM      1  OT  GMT-    0       1.583   1.785   1.480  1.00178.02           O-2\n\
ATOM      2  HT  GMT-    0       1.186   1.643   2.213  1.00103.58           H+1\n\
ATOM      3  HT  GMT-    0       2.642   1.896   1.730  1.00126.00           H+1\n\
ATOM      4  OT  GMT-    1       3.583   1.785   1.480  1.00178.02           O-2\n\
ATOM      5  HT  GMT-    1       3.186   1.643   2.213  1.00103.58           H+1\n\
ATOM      6  HT  GMT-    1       4.642   1.896   1.730  1.00126.00           H+1\n\
CONECT    1    2    3\n\
CONECT    2    1\n\
CONECT    3    1\n\
CONECT    4    5    6\n\
CONECT    5    4\n\
CONECT    6    4\n\
END";

void ParserPdbUnitTest::setUp() {
  World::getInstance();

  setVerbosity(2);

  // we need hydrogens and oxygens in the following tests
  CPPUNIT_ASSERT(World::getInstance().getPeriode()->FindElement(1) != NULL);
  CPPUNIT_ASSERT(World::getInstance().getPeriode()->FindElement(8) != NULL);
}

void ParserPdbUnitTest::tearDown() {
  ChangeTracker::purgeInstance();
  World::purgeInstance();
}

/************************************ tests ***********************************/

void ParserPdbUnitTest::readwritePdbTest() {
  stringstream input;
  input << waterPdb;
  PdbParser* testParser = new PdbParser();
  testParser->load(&input);
  input.clear();

  CPPUNIT_ASSERT_EQUAL(6, World::getInstance().numAtoms());

  stringstream output;
  std::vector<atom *> atoms = World::getInstance().getAllAtoms();
  testParser->save(&output, atoms);

//  std::cout << "Save PDB is:" << std::endl;
//  std::cout << output.str() << std::endl;

  input << output.str();
  PdbParser* testParser2 = new PdbParser();
  testParser2->load(&input);

  CPPUNIT_ASSERT_EQUAL(12, World::getInstance().numAtoms());
}
