/** \file defs.hpp
 * 
 * Constant definitons and enumerations.
 * 
 */

#ifndef DEFS_HPP_
#define DEFS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


enum { MAX_ELEMENTS = 128}; //!< maximum number of elements for certain lookup tables

extern "C" const double MYEPSILON;  //!< machine epsilon precision
extern "C" const double AtomicLengthToAngstroem; //!< conversion factor from atomic length/bohrradius to angstroem
extern "C" const double AtomicEnergyToKelvin;  //!< conversion factor from atomic energy to kelvin via boltzmann factor
extern "C" const double KelvinToAtomicTemperature;    //!< conversion factor for Kelvin to atomic temperature (Hartree over k_B)
extern "C" const double KelvinToeV;                   //!< conversion factor for Kelvin to Ht (k_B * T = energy), thus Boltzmann constant in eV/K
extern "C" const double AtomicMassUnitsToeV;        //!< conversion factor for atomic weight in units to mass in eV
extern "C" const double AtomicMassUnitsToHt;        //!< conversion factor for atomic weight in units to mass in Ht (protonmass/electronmass * electron_mass_in_Ht
extern "C" const double ElectronMass_Ht;            //!< electron mass in Ht
extern "C" const double ElectronMass_eV;           //!< electron mass in eV
extern "C" const double Units2Electronmass; //!< atomic mass unit in eV/ electron mass in eV = 1 822.88863
extern "C" const double Atomictime2Femtoseconds;     //!< Atomictime in fs

extern "C" const char* VERSIONSTRING;

extern "C" const char* LocalPath;

//enum BondOrderScheme { NoScheme, BottomUp, TopDown, ANOVA, Combined }; //!< Fragmentation scheme used in BOSS

//enum CutCyclicBond { KeepBond,  SaturateBond }; //!< Saturation scheme either atom- or bondwise 

// Specifting whether a value in the parameter file must be specified or is optional
enum necessity { optional,    //!< parameter is optional, if not given sensible value is chosen
                 critical     //!< parameter must be given or programme won't initiate
               };

// Specifying the status of the on command line given config file
enum ConfigStatus { absent, empty, present };

// Specifying the cast type to be read of a parameter, see ParseForParameter()
enum value_type { string_type, double_type, int_type, row_int, row_double, grid, lower_trigrid, upper_trigrid}; 

// maximum length of any char array
enum { MAXSTRINGSIZE = 255 };

// various standard filenames
extern "C" const char *DEFAULTCONFIG;    //!< default filename of config file
extern "C" const char *CONVEXENVELOPE;    //!< default filename of convex envelope tecplot data file
extern "C" const char *KEYSETFILE;    //!< default filename of BOSSANOVA key sets file
extern "C" const char *ADJACENCYFILE;    //!< default filename of BOSSANOVA adjacancy file
extern "C" const char *TEFACTORSFILE;    //!< default filename of BOSSANOVA total energy factors file
extern "C" const char *FORCESFILE;    //!< default filename of BOSSANOVA force factors file
extern "C" const char *HCORRECTIONSUFFIX;    //!< default filename of BOSSANOVA H correction file (unwanted saturation interaction)
extern "C" const char *FITCONSTANTSUFFIX;   //!< suffix of default filename of BOSSANOVA fit constants file (unwanted saturation interaction)
extern "C" const char *SHIELDINGSUFFIX;                //!< default filename of BOSSANOVA shieldings file
extern "C" const char *SHIELDINGPASSUFFIX;                 //!< default filename of BOSSANOVA shieldings PAS file
extern "C" const char *ORDERATSITEFILE;    //!< default filename of BOSSANOVA Bond Order at each atom file
extern "C" const char *ENERGYPERFRAGMENT;    //!< default filename of BOSSANOVA Energy contribution Per Fragment file
extern "C" const char *FRAGMENTPREFIX;    //!< default filename prefix of BOSSANOVA fragment config and directories
extern "C" const char *STANDARDCONFIG;    //!< default filename of standard config file
extern "C" const char *STANDARDELECTRONEGATIVITYDB;    //!< default filename of electronegativity per element data base
extern "C" const char *STANDARDELEMENTSDB;    //!< default filename of elements data base with masses, Z, VanDerWaals radii, ...
extern "C" const char *STANDARDVALENCEDB;    //!< default filename of valence number per element database
extern "C" const char *STANDARDORBITALDB;    //!< default filename of orbitals per element database
extern "C" const char *STANDARDHBONDDISTANCEDB;    //!< default filename of typial bond distance to hydrogen database
extern "C" const char *STANDARDHBONDANGLEDB;    //!< default filename of typial bond angle to hydrogen database

// some values
extern "C" const double SOLVENTDENSITY_A;
extern "C" const double SOLVENTDENSITY_a0;


extern "C" const int UPDATECOUNT;  //!< update ten sites per BOSSANOVA interval

extern "C" const int STD_MENU_LENGTH;
extern "C" const char STD_MENU_TITLE_SPACER;
extern "C" const char STD_SEPERATOR_SPACER;

extern "C" const char *MOLECUILDER_NAME;

const extern unsigned int MAX_POOL_FRAGMENTATION;
const extern unsigned int MAX_FRAGMENTATION_SKIPS;

#endif /*DEFS_HPP_*/
