/** \file helpers.hpp
 *
 * Declaration of some auxiliary functions for memory dis-/allocation and so on
 */

#ifndef HELPERS_HPP_
#define HELPERS_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cstdlib>

/********************************************** helpful template functions *********************************/


inline void performCriticalExit()
{
  exit(255);
}


// this is to allow different modes of access for
// maps and sets
template<typename Res,typename T>
struct _take{
  Res get(T value) const;
};

// if we have a set,vector etc we can directly access the result
template<typename Res>
struct _take<Res,Res>{
  static inline Res get(Res value){
    return value;
  }
};

// if we have a map we have to access the second part of
// the pair
template<typename Res,typename T1>
struct _take<Res,std::pair<T1,Res> >{
  static inline Res get(std::pair<T1,Res> value){
    return value.second;
  }
};

#endif /*HELPERS_HPP_*/
