/*
 * OutputTemperature.hpp
 *
 *  Created on: Feb 23, 2011
 *      Author: heber
 */

#ifndef OUTPUTTEMPERATURE_HPP_
#define OUTPUTTEMPERATURE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/defs.hpp"

template <class T>
class OutputTemperature
{
public:
  OutputTemperature(AtomSetMixin<T> &_atoms) :
    atoms(_atoms)
  {}
  ~OutputTemperature()
  {}

  /** Stores the temperature evaluated from velocities in molecule::Trajectories.
   * We simply use the formula equivaleting temperature and kinetic energy:
   * \f$k_B T = \sum_i m_i v_i^2\f$
   * \param *output output stream of temperature file
   * \param startstep first MD step in molecule::Trajectories
   * \param endstep last plus one MD step in molecule::Trajectories
   * \return file written (true), failure on writing file (false)
   */
  bool operator()(ofstream * const output, int startstep, int endstep)
  {
    double temperature;
    // test stream
    if (output == NULL)
      return false;
    else
      *output << "# Step Temperature [K] Temperature [a.u.]" << endl;
    for (int step=startstep;step < endstep; step++) { // loop over all time steps
      temperature = atoms.totalTemperatureAtStep(step);
      *output << step << "\t" << temperature*AtomicEnergyToKelvin << "\t" << temperature << endl;
    }
    return true;
  };

private:
  AtomSetMixin<T> atoms;
};

#endif /* OUTPUTTEMPERATURE_HPP_ */
