/*
 * QtMoleculeItem_name.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_NAME_HPP_
#define QTMOLECULEITEM_NAME_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

class QtMoleculeItemFactory;

/** This class contains the name of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_name : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_name(
      QtObservedMolecule::ptr &_ObservedMolecule) :
        QtMoleculeItem(_ObservedMolecule)
  {
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  /** Performs the update of the molecule's name.
   *
   */
  void internal_updateState()
  {
    setText(QString(ObservedMolecule->getMolName().c_str()));
  }

  QtMoleculeItem::COLUMNTYPES getType() const
  { return QtMoleculeItem::NAME; }
};


#endif /* QTMOLECULEITEM_NAME_HPP_ */
