/*
 * QtMoleculeItem.hpp
 *
 *  Created on: Jan 17, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_HPP_
#define QTMOLECULEITEM_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QList>
#include <QStandardItem>

#include <boost/function.hpp>
#include <boost/thread/recursive_mutex.hpp>
#include <list>
#include <string>

#include "UIElements/Qt4/InstanceBoard/QtObservedMolecule.hpp"

/** This class describes the general interface for a specific item in a QtAbstractItemModel
 * to contain a specific piece of information about a specific molecule.
 *
 * To this end, we need a ref to the molecule for updating the information when
 * necessary and we need to know the channels we have to listen to know when an
 * update is necessary.
 *
 * This class takes care of of all the rest:
 * -# informing QtMoleculeList about required update ("dirty")
 * -# relaying updateState() call from QtMoleculeList to the specific internal_updateState()
 */
class QtMoleculeItem : public QStandardItem
{
public:
  //!> enumerates all different item types, coinciding with column in QtMoleculeList
  enum COLUMNTYPES {NAME,VISIBILITY,ATOMCOUNT,FORMULA,OCCURRENCE,COLUMNTYPES_MAX};

  QtMoleculeItem(
      QtObservedMolecule::ptr &_ObservedMolecule);
  virtual ~QtMoleculeItem();

  /** Update the state of this item.
   *
   */
  void updateState();

  /** Returns the type of this QtMoleculeItem, i.e. the column in QtMoleculeList.
   *
   * @return type of this item
   */
  virtual QtMoleculeItem::COLUMNTYPES getType() const = 0;

  /** Getter to the observed molecule in this item.
   *
   * \return const ref to ObservedMolecule for this item
   */
  const QtObservedMolecule::ptr& getMolecule() const
  { return ObservedMolecule; }

  /** Getter for the id of the observed molecule for this item.
   *
   * \return id of the observed molecule
   */
  const moleculeId_t getMoleculeId() const
  { return ObservedMolecule->getMolIndex(); }

protected:
  /** This function needs to be implemented to make the specific update.
   *
   */
  virtual void internal_updateState() = 0;

  //!> ptr to ObservedMolecule we follow
  const QtObservedMolecule::ptr ObservedMolecule;

private:
  //!> states that this item needs to be updated
  bool dirty;
};


#endif /* QTMOLECULEITEM_HPP_ */
