/*
 * TranslateAction.hpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#ifndef TRANSLATEACTION_HPP
#define TRANSLATEACTION_HPP

#include "Actions/Action.hpp"
#include "LinearAlgebra/Vector.hpp"

void AtomTranslate(Vector &x, bool periodic);

class AtomTranslateAction : public Action {
  friend void AtomTranslate(Vector &x);

public:
  AtomTranslateAction();
  virtual ~AtomTranslateAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog *dialog);
private:
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};


#endif // TRANSLATEACTION_HPP
