/*
 * ClearAllMoleculesAction.cpp
 *
 *  Created on: Aug 09, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/ClearAllMoleculesAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionClearAllMoleculesState : public ActionState {
public:
  SelectionClearAllMoleculesState(std::vector<molecule*> selectedMolecules) :
    selectedMolecules(selectedMolecules)
  {}
  std::vector<molecule*> selectedMolecules;
};

const char SelectionClearAllMoleculesAction::NAME[] = "clear-molecule-selection";

SelectionClearAllMoleculesAction::SelectionClearAllMoleculesAction() :
  Action(NAME)
{}

SelectionClearAllMoleculesAction::~SelectionClearAllMoleculesAction()
{}

void SelectionClearAllMolecules() {
  ActionRegistry::getInstance().getActionByName(SelectionClearAllMoleculesAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionClearAllMoleculesAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionClearAllMoleculesAction::performCall() {
  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Clearing molecule selection." << endl);
  World::getInstance().clearMoleculeSelection();
  return Action::state_ptr(new SelectionClearAllMoleculesState(selectedMolecules));
}

Action::state_ptr SelectionClearAllMoleculesAction::performUndo(Action::state_ptr _state) {
  SelectionClearAllMoleculesState *state = assert_cast<SelectionClearAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  for(std::vector<molecule *>::iterator iter = state->selectedMolecules.begin(); iter != state->selectedMolecules.end(); ++iter)
    World::getInstance().selectMolecule(*iter);

  return Action::state_ptr(new SelectionClearAllMoleculesState(state->selectedMolecules));
}

Action::state_ptr SelectionClearAllMoleculesAction::performRedo(Action::state_ptr _state){
  SelectionClearAllMoleculesState *state = assert_cast<SelectionClearAllMoleculesState*>(_state.get());

  World::getInstance().clearMoleculeSelection();

  return Action::state_ptr(new SelectionClearAllMoleculesState(state->selectedMolecules));
}

bool SelectionClearAllMoleculesAction::canUndo() {
  return true;
}

bool SelectionClearAllMoleculesAction::shouldUndo() {
  return true;
}

const string SelectionClearAllMoleculesAction::getName() {
  return NAME;
}
