/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * StreamFactory_EmpiricalPotential.cpp
 *
 *  Created on: Feb 28, 2016
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Log.hpp"

#include "Potentials/Exceptions.hpp"
#include "StreamFactory_EmpiricalPotential.hpp"

StreamFactory<EmpiricalPotential>::~StreamFactory<EmpiricalPotential>()
{}

EmpiricalPotential *
StreamFactory<EmpiricalPotential>::createInstance(
    const std::string &potentialtype,
    std::istream &serialized) const
{
  EmpiricalPotential * full_potential;
  // now stream in types and parameters
  try {
    EmpiricalPotential * const potential = getDefaultPotential(potentialtype);
    potential->stream_from(serialized);
    // also need to generate the binding model
    full_potential = createInstance(potentialtype, potential->getParticleTypes());
    delete potential;
  } catch (SerializerMissingValueException &e) {
    ELOG(1, "Missing value for potential in line " << e.what());
  }

  return full_potential;
}
