/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * PrincipalAxisSystemAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "element.hpp"
#include "molecule.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/AnalysisAction/PrincipalAxisSystemAction.hpp"

// and construct the stuff
#include "PrincipalAxisSystemAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr AnalysisPrincipalAxisSystemAction::performCall() {
  DoLog(0) && (Log() << Verbose(0) << "Evaluating prinicipal axis." << endl);
  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    molecule *mol = iter->second;

    // get inertia tensor
    RealSpaceMatrix InertiaTensor = mol->getInertiaTensor();

		// diagonalize matrix
    Vector EigenValues = InertiaTensor.transformToEigenbasis();

    // print principal axis system
    DoLog(0) && (Log() << Verbose(0) << "The Principal Axis System of molecule "
        << mol->getName() <<  " is:"
        << InertiaTensor << endl
        << " with eigenvalues "
        << EigenValues << endl);
  }
  return Action::success;
}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPrincipalAxisSystemAction::canUndo() {
  return true;
}

bool AnalysisPrincipalAxisSystemAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
