/*
 * bond_observable.hpp
 *
 *  Created on: Jan 5, 2012
 *      Author: heber
 */

#ifndef BOND_OBSERVABLE_HPP_
#define BOND_OBSERVABLE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "CodePatterns/Observer/Channels.hpp"
#include "CodePatterns/Observer/Observable.hpp"

#include <map>

/** This class encapsulates Observable pattern along with required notification
 *  types.
 */
class BondObservable : public Observable
{
public:
  enum NotificationType {
    BondRemoved,          // bond is about to be removed
    DegreeChanged,        // bond degree is different
    NotificationType_MAX  // denotes the maximum of available notification types
  };

  BondObservable();
  virtual ~BondObservable();
};


#endif /* BOND_OBSERVABLE_HPP_ */
