/*
 * MakroAction.cpp
 *
 *  Created on: Dec 17, 2009
 *      Author: crueger
 */

#include <string>

#include "Actions/MakroAction.hpp"
#include "Actions/Action.hpp"
#include "Actions/ActionSequence.hpp"

using namespace std;

MakroAction::MakroAction(string _name,ActionSequence* _actions,bool _doRegister) :
Action(_name,_doRegister),
actions(_actions)
{
}

MakroAction::~MakroAction()
{
  Action* action;
  while((action=actions->removeLastAction())){
    delete action;
  }
  delete actions;
}


void MakroAction::call(){
  actions->callAll();
}

void MakroAction::undo() {
  actions->undoAll();
}

bool MakroAction::canUndo() {
  return actions->canUndo();
}
