/*
 * QtElementList.h
 *
 *  Created on: Mar 6, 2012
 *      Author: ankele
 */

#ifndef QTELEMENTLIST_H_
#define QTELEMENTLIST_H_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <QtGui/QTreeWidget>
#include <QMutex>

#include "CodePatterns/Observer/Observer.hpp"
#include "CodePatterns/Observer/Notification.hpp"

#include "types.hpp"

#include "UIElements/Qt4/InstanceBoard/QtObservedAtom.hpp"

class QtObservedInstanceBoard;

class QtElementList: public QTreeWidget, public Observer
{
  Q_OBJECT

public:
  QtElementList(QtObservedInstanceBoard *_board, QWidget * _parent=0);
  virtual ~QtElementList();

protected:
  virtual void update(Observable *publisher);
  virtual void recieveNotification(Observable *publisher, Notification_ptr notification);
  virtual void subjectKilled(Observable *publisher);
  virtual void paintEvent(QPaintEvent * event);

  void setOccurrence(QTreeWidgetItem &_item, const int count);
  void updateElement(const QtObservedAtom::ptr &_atom);

  static const int COLUMNCOUNT;
  enum COLUMNTYPES {NUMBER,NAME,SYMBOL,MASS,OCCURRENCE,COLUMNTYPES_MAX};
  static const char *COLUMNNAMES[];

signals:
  void needsRefill(const atomId_t);

private slots:
  void rowSelected();
  void refill(const atomId_t);

private:
  std::vector<bool> elementSelection; //!< needed to determine when a selection changes
  typedef std::map<atomId_t, atomicNumber_t> AtomElementMap_t;
  AtomElementMap_t AtomElementMap;
  bool dirty;

  //!> ptr to instance board to obtain observed atoms
  QtObservedInstanceBoard * const board;

  QMutex refill_mutex;
};

#endif /* QTELEMENTLIST_H_ */
