/*
 * QtElementList.h
 *
 *  Created on: Mar 6, 2012
 *      Author: ankele
 */

#ifndef QTELEMENTLIST_H_
#define QTELEMENTLIST_H_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <QtGui/QTreeWidget>
#include "CodePatterns/Observer/Observer.hpp"

class molecule;
class MoleculeListClass;

class QtElementList: public QTreeWidget, public Observer
{
  Q_OBJECT

public:
  QtElementList(QWidget * _parent=0);
  virtual ~QtElementList();

protected:
  virtual void update(Observable *publisher);
  virtual void subjectKilled(Observable *publisher);

  static const int COLUMNCOUNT;
  enum {NUMBER,NAME,SYMBOL,MASS,OCCURRENCE,COLUMNTYPES_MAX} COLUMNTYPES;
  static const char *COLUMNNAMES[];

private slots:
  void rowSelected();

signals:
  void moleculeSelected(molecule*);
  void moleculeUnSelected(molecule*);

private:
  std::vector<bool> elementSelection; //!< needed to determine when a selection changes
  MoleculeListClass *molecules;
  bool dirty;
};

#endif /* QTELEMENTLIST_H_ */
