/*
 * TranslateAction.hpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#ifndef TRANSLATEACTION_HPP
#define TRANSLATEACTION_HPP

#include "Actions/Action.hpp"
#include "Actions/Process.hpp"
#include "vector.hpp"

class MoleculeListClass;

class MoleculeTranslateAction : public Action {
  friend void MoleculeTranslate(Vector &x, bool periodic);

public:
  MoleculeTranslateAction();
  virtual ~MoleculeTranslateAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
private:
  virtual Dialog * createDialog();
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};


#endif // TRANSLATEACTION_HPP
