/*
 * ElementDbAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Actions/CmdAction/ElementDbAction.hpp"
#include "config.hpp"
#include "log.hpp"
#include "periodentafel.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char CommandLineElementDbAction::NAME[] = "element-db";

CommandLineElementDbAction::CommandLineElementDbAction() :
  Action(NAME)
{}

CommandLineElementDbAction::~CommandLineElementDbAction()
{}

Action::state_ptr CommandLineElementDbAction::performCall() {
  ostringstream usage;
  string databasepath;
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  // get the path
  // TODO: Make databasepath a std::string
  config *configuration = World::getInstance().getConfig();
  dialog->queryString(NAME, &databasepath, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    strcpy(configuration->databasepath, databasepath.c_str());
    delete dialog;
  } else {
    delete dialog;
    return Action::failure;
  }

  // load table
  periodentafel *periode = World::getInstance().getPeriode();
  if (periode->LoadPeriodentafel(configuration->databasepath)) {
    DoLog(0) && (Log() << Verbose(0) << "Element list loaded successfully." << endl);
    //periode->Output();
    return Action::success;
  } else {
    DoLog(0) && (Log() << Verbose(0) << "Element list loading failed." << endl);
    return Action::failure;
  }

}

Action::state_ptr CommandLineElementDbAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr CommandLineElementDbAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool CommandLineElementDbAction::canUndo() {
  return false;
}

bool CommandLineElementDbAction::shouldUndo() {
  return false;
}

const string CommandLineElementDbAction::getName() {
  return NAME;
}
