/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorZeroOneComponentsValidator.cpp
 *
 *  Created on: May 10, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "VectorZeroOneComponentsValidator.hpp"

bool VectorZeroOneComponentsValidator::isValid(const Vector & _value) const
{
  bool status = true;
  for (size_t i=0;i<NDIM;++i)
    status = status && (_value[i] >= 0) && (_value[i] <= 1);
  return status;
}

bool VectorZeroOneComponentsValidator::operator==(const Validator<Vector> &_instance) const
{
  const VectorZeroOneComponentsValidator *inst =
      dynamic_cast<const VectorZeroOneComponentsValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< Vector >* VectorZeroOneComponentsValidator::clone() const
{
  Validator< Vector > *inst =
      new VectorZeroOneComponentsValidator();
  return inst;
}




