/*
 * WindowGrid_converter.hpp
 *
 *  Created on: Dec 20, 2012
 *      Author: heber
 */

#ifndef WINDOWGRID_CONVERTER_HPP_
#define WINDOWGRID_CONVERTER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

namespace VMG {
  class Grid;
}

class SamplingGrid;

namespace WindowGrid_converter {
  /** Helper function to copy VMG's Grid onto the non-zero window of a SamplingGrid
   *
   * The code is very similar to SamplingGrid::addOntoWindow().
   *
   * @param grid grid with non-zero window
   * @param prefactor factor for each added value, e.g. -1. makes a subtraction
   * @param OpenBoundaryConditions states whether we have open (true) or 
   *        periodic (false) boundary conditions
   */
  void addGridOntoWindow(
      VMG::Grid& grid,
      SamplingGrid &window,
      const double prefactor,
      const bool OpenBoundaryConditions = false);

  /** Helper function to copy non-zero window in SamplingGrid onto VMG's Grid.
   *
   * The code is very similar to SamplingGrid::addOntoWindow().
   *
   * @param grid grid with non-zero window
   * @param prefactor factor for each added value, e.g. -1. makes a subtraction
   * @param OpenBoundaryConditions states whether we have open (true) or 
   *        periodic (false) boundary conditions
   */
  void addWindowOntoGrid(
      VMG::Grid& window,
      const SamplingGrid &grid,
      const double prefactor,
      const bool OpenBoundaryConditions = false,
      const bool DoSmearCharges = false);

};


#endif /* WINDOWGRID_CONVERTER_HPP_ */
