/*
 * InterfaceVMGJob.hpp
 *
 *  Created on: 10.06.2012
 *      Author: Frederik Heber
 */

#ifndef INTERFACEVMGJOB_HPP_
#define INTERFACEVMGJOB_HPP_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/function.hpp>

#include "base/interface.hpp"
#include "base/vector.hpp"
#include "units/particle/bspline.hpp"
#include "units/particle/particle.hpp"

#include "Fragmentation/Summation/Containers/VMGData.hpp"
#include "Fragmentation/Summation/SetValues/SamplingGrid.hpp"

namespace VMG
{
class Grid;
class MGGrid;
class MGMultigrid;
}

namespace VMGInterfaces
{

class InterfaceVMGJob : public VMG::Interface
{
public:
  enum ImportParticles_t {
    DontImportParticles=0,
    DoImportParticles=1,
  };

  InterfaceVMGJob(const SamplingGrid &_sampled_input,
      VMGData &returndata,
      const std::vector< std::vector< double > > &_particle_positions,
      const std::vector< double > &_particle_charges,
      VMG::Boundary boundary,
      int levelMin,
      int levelMax,
      const VMG::Vector &_box_begin,
      vmg_float _box_end,
      const int& near_field_cells,
      const ImportParticles_t _ImportParticles=DoImportParticles,
      const bool _DoPrintDebug=false,
      const bool _DoSmearCharges=false,
      int coarseningSteps=9,
      double alpha=1.6
      );

  ~InterfaceVMGJob() {}

  void ImportRightHandSide(VMG::Multigrid& multigrid);
  void ExportSolution(VMG::Grid& grid);

protected:
  unsigned int nfc;
  const double meshwidth;
  VMG::Particle::BSpline spl;

private:
  //!> sampled density on the grid as input
  const SamplingGrid sampled_input;
  //!> sampled potential on the grid as output
  VMGData &returndata;
  //!> number of grid points per axis as \f$2^{\mathrm{level}}\f$
  const int level;
  //!> nuclei charges
  std::list<VMG::Particle::Particle> particles;

  //!> contains start of grid intervals
  double box_begin[3];
  //!> contains end of grid intervals
  double box_end[3];

  //!> whether we import particles (true) or evaluate only
  const ImportParticles_t ImportParticles;

  //!> whether we do print grid for debug visualization or not
  const bool DoPrintDebug;

  //!> open boundary conditions or not
  const bool OpenBoundaryCondition;

  //!> whether to smear out electronic charge distributions with bsplines or not
  const bool DoSmearCharges;
};

}

#endif /* INTERFACEVMGJOB_HPP_ */
