/*
 * PdbParser.hpp
 *
 *  Created on: Aug 17, 2010
 *      Author: heber
 */

#ifndef PDBPARSER_HPP_
#define PDBPARSER_HPP_

#include <string>
#include "FormatParser.hpp"
#include "PdbAtomInfoContainer.hpp"
#include "PdbKey.hpp"

/**
 * Loads a PDB format 3.2 file into the World and saves the World as a PDB file.
 */
class PdbParser : public FormatParser
{
public:
  PdbParser();
  ~PdbParser();
  void load(std::istream* file);
  void save(std::ostream* file);

  bool operator==(const PdbParser& b) const;
  void printAtomInfo(const atom *newAtom) const;

private:
  enum PdbKey::KnownTokens getToken(string &line);
  void readAtomDataLine(string &line, molecule *newmol);
  void parseAtomDataKeysLine(string line, int offset);
  void readNeighbors(std::string &line);
//  void adaptImprData();
//  void adaptTorsion();
//  std::string adaptIdDependentDataString(std::string data);
  bool isUsedField(std::string fieldName);
  void writeNeighbors(std::ostream* file, int numberOfNeighbors, atom* currentAtom);
  void saveLine(ostream* file, const PdbAtomInfoContainer &atomInfo);

  // internal getter and setter
  size_t getSerial(const size_t atomid) const;
  void setSerial(const size_t localatomid, const size_t atomid);

  /**
   * argh, why can't just PdbKey::X+(size_t)i
   */
  std::map<size_t, PdbKey::PdbDataKey> PositionEnumMap;

  /**
   * Map to associate the known keys with numbers.
   */
  std::map<std::string, PdbKey::KnownTokens> knownTokens;

  /**
   * Data which is currently not stored in atoms but was provided by the input
   * file.
   */
  std::map<size_t, PdbAtomInfoContainer> additionalAtomData;

  /**
   * Default additional atom data.
   */
  PdbAtomInfoContainer defaultAdditionalData;

  /**
   * Maps original atom IDs received from the parsed file to atom IDs in the
   * world.
   */
  std::map<size_t, size_t> atomIdMap;

  /**
   * Maps original atom IDs received from the parsed file to atom IDs in the
   * world.
   */
  std::set<size_t> SerialSet;

};

#endif /* PDBPARSER_HPP_ */
