/*
 * analysisbondsunittest.cpp
 *
 *  Created on: Nov 7, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <iostream>
#include <stdio.h>
#include <cstring>

#include "MapOfActionsTest.hpp"
#include "Actions/MapOfActions.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( MapOfActionsTest );


void MapOfActionsTest::setUp()
{
  MapOfActions *ActionData = MapOfActions::getInstance();
};


void MapOfActionsTest::tearDown()
{
  // note that all the atoms are cleaned by TestMolecule
  MapOfActions::purgeInstance();
};

/** UnitTest: check whether each short form action also has a description (the other way round is not always true)
 */
void MapOfActionsTest::ShortFormConsistencyTest()
{
  for (map<string, string>::iterator ShortFormRunner = ActionData->ShortFormMap.begin(); ShortFormRunner = ActionData->ShortFormMap.begin(); ++ShortFormRunner) {
    CPPUNIT_ASSERT( ActionData->DescriptionMap.find(ShortFormRunner->first) != ActionData->DescriptionMap.end() && "There is a short form without description.");
  }
};

/** UnitTest: check whether each action appears in a list one of the option lists
 */
void MapOfActionsTest::OptionsListsConsistencyTest()
{
  bool haveFound = false;
  for (map<string, string>::iterator ActionRunner = ActionData->DescriptionMap.begin(); ShortFormRunner = ActionData->DescriptionMap.begin(); ++ShortFormRunner) {
    haveFound = haveFound || (ActionData->generic.find(ActionRunner->first) != ActionData->generic.end());
    haveFound = haveFound || (ActionData->config.find(ActionRunner->first) != ActionData->config.end());
    haveFound = haveFound || (ActionData->hidden.find(ActionRunner->first) != ActionData->hidden.end());
    haveFound = haveFound || (ActionData->visible.find(ActionRunner->first) != ActionData->visible.end());
    CPPUNIT_ASSERT_EQUAL( true , haveFound);
  }
};

