/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the COPYING file or "Copyright notice" in builder.cpp for details.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>. 
 */

/*
 * HomologyContainer.cpp
 *
 *  Created on: Sep 22, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
// otherwise BOOST_CLASS_EXPORT_IMPLEMENT has no effect
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "HomologyContainer.hpp"

#include <iostream>

#include "Fragmentation/Graph.hpp"

std::ostream& operator<<(std::ostream &out, const HomologyContainer &homologycontainer)
{
  for(HomologyContainer::container_t::const_iterator iter = homologycontainer.container.begin();
      iter != homologycontainer.container.end(); ++iter) {
    out << "Graph: " << iter->first
        << ", (Fragment " << iter->second.first
        << ":" << iter->second.second << ")\n";
  }
  return out;
}

std::ostream& operator<<(std::ostream &out, const Fragment &container)
{
  out << "Dummy fragment";
  return out;
}

bool HomologyContainer::operator>=(const HomologyContainer &other) const
{
  bool status = true;
  // go through this container and check each element for presence in other
  for (container_t::const_iterator iter = container.begin();
      iter != container.end(); ++iter) {
    // get all values in other container to the same graph
    std::pair<
      container_t::const_iterator,
      container_t::const_iterator>
      keyrange = other.container.equal_range(iter->first);
    container_t::const_iterator otheriter = keyrange.first;
    for (;otheriter != keyrange.second;
        ++otheriter)
      if (otheriter->second == iter->second)
        break;
    status &= (otheriter != keyrange.second);
  }
  return status;
}

// we need to explicitly instantiate the serialization functions
BOOST_CLASS_EXPORT_IMPLEMENT(HomologyContainer)

