/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SetOutputFormatsAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Parser/ChangeTracker.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "SetOutputFormatsAction.hpp"

// and construct the stuff
#include "SetOutputFormatsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ParserSetOutputFormatsAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Format list is: " << params.FormatList << std::endl);
  for (vector<std::string>::iterator iter = params.FormatList.begin(); iter != params.FormatList.end(); ++iter) {
    if (!FormatParserStorage::getInstance().add(*iter)) {
      DoeLog(1) && (eLog() << Verbose(1) << "Unknown parser format in ParserSetOutputFormatsAction: '" << *iter << "'" << endl);
    }
  }
  return Action::success;
}

Action::state_ptr ParserSetOutputFormatsAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr ParserSetOutputFormatsAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool ParserSetOutputFormatsAction::canUndo() {
  return false;
}

bool ParserSetOutputFormatsAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
