/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DepthFirstSearchAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "bondgraph.hpp"
#include "config.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/FragmentationAction/DepthFirstSearchAction.hpp"

// and construct the stuff
#include "DepthFirstSearchAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr FragmentationDepthFirstSearchAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Depth-First-Search Analysis." << endl);
  molecule * const mol = World::getInstance().getMolecule(MoleculeById(0));
  MoleculeLeafClass *Subgraphs = NULL;      // list of subgraphs from DFS analysis
  int *MinimumRingSize = new int[mol->getAtomCount()];
  atom **ListOfAtoms = NULL;
  std::deque<bond *> *BackEdgeStack = NULL;
  std::deque<bond *> *LocalBackEdgeStack = NULL;
  BondGraph *BG = World::getInstance().getConfig()->BG;
  if (BG != NULL)
    mol->CreateAdjacencyList(params.distance, World::getInstance().getConfig()->GetIsAngstroem(), &BondGraph::BondLengthMatrixMinMaxDistance, BG);
  else
    mol->CreateAdjacencyList(params.distance, World::getInstance().getConfig()->GetIsAngstroem(), &BondGraph::CovalentMinMaxDistance, BG);
  Subgraphs = mol->DepthFirstSearchAnalysis(BackEdgeStack);
  if (Subgraphs != NULL) {
    int FragmentCounter = 0;
    while (Subgraphs->next != NULL) {
      Subgraphs = Subgraphs->next;
      ListOfAtoms = NULL;
      Subgraphs->FillBondStructureFromReference(mol, ListOfAtoms, false);  // we want to keep the created ListOfLocalAtoms
      LocalBackEdgeStack = new std::deque<bond *>; // no need to have it Subgraphs->Leaf->BondCount size
      Subgraphs->Leaf->PickLocalBackEdges(ListOfAtoms, BackEdgeStack, LocalBackEdgeStack);
      Subgraphs->Leaf->CyclicStructureAnalysis(LocalBackEdgeStack, MinimumRingSize);
      delete(LocalBackEdgeStack);
      delete(Subgraphs->previous);
      delete[](ListOfAtoms);  // and here we remove it
      FragmentCounter++;
    }
    delete(Subgraphs);
  }
  delete(BackEdgeStack);
  delete[](MinimumRingSize);
  return Action::success;
}

Action::state_ptr FragmentationDepthFirstSearchAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr FragmentationDepthFirstSearchAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool FragmentationDepthFirstSearchAction::canUndo() {
  return true;
}

bool FragmentationDepthFirstSearchAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
