/*
 * TremoloAtomInfoContainer.hpp
 *
 *  Created on: Dec 7, 2010
 *      Author: heber
 */

#ifndef TREMOLOATOMINFOCONTAINER_HPP_
#define TREMOLOATOMINFOCONTAINER_HPP_

#include <string>
#include <vector>

#include "TremoloKey.hpp"

/**
 * Holds tremolo-specific information which is not store in the atom class.
 */
class TremoloAtomInfoContainer {
public:
  TremoloAtomInfoContainer();
  void set(TremoloKey::atomDataKey key, std::string value);
  std::string get(TremoloKey::atomDataKey key);
  std::string F;
  std::string stress;
  std::string imprData;
  std::string GroupMeasureTypeNo;
  std::string extType;
  std::string name;
  std::string resName;
  std::string chainID;
  std::string resSeq;
  std::string occupancy;
  std::string tempFactor;
  std::string segID;
  std::string Charge;
  std::string charge;
  std::string GrpTypeNo;
  std::string torsion;
  std::vector<int> neighbors;
  bool neighbors_processed;
};


#endif /* TREMOLOATOMINFOCONTAINER_HPP_ */
