/*
 * NoThermostat.hpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#ifndef NOTHERMOSTAT_HPP_
#define NOTHERMOSTAT_HPP_

#include "Thermostats/Thermostat.hpp"

class NoThermostat : public Thermostat
{
public:
  NoThermostat();
  virtual ~NoThermostat();

  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::list) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::vector) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::set) atoms);

  virtual std::string name();
  virtual std::string writeParams();
};

template <>
struct ThermostatTraits<class NoThermostat>: public ThermostatTraits<Thermostat>
{
  ThermostatTraits();
  const char* name;
};

#endif /* NOTHERMOSTAT_HPP_ */
