/*
 * Langevin.hpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#ifndef LANGEVIN_HPP_
#define LANGEVIN_HPP_

#include "Thermostats/Thermostat.hpp"

class Langevin : public Thermostat
{
public:
  Langevin();
  virtual ~Langevin();

  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::list) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::vector) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::set) atoms);

  virtual std::string name();
  virtual std::string writeParams();

private:
  template <class ForwardIterator>
  double doScaleAtoms(unsigned int step,double ActualTemp,ForwardIterator begin, ForwardIterator end);


  double TempFrequency;
  double alpha;
  gsl_rng * r;
  const gsl_rng_type * T;
};

template <>
struct ThermostatTraits<class Langevin> : public ThermostatTraits<Thermostat>
{
  ThermostatTraits();
  const char* name;
};

#endif /* LANGEVIN_HPP_ */
