/*
 * Berendsen.hpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#ifndef BERENDSEN_HPP_
#define BERENDSEN_HPP_

#include "Thermostats/Thermostat.hpp"

class Berendsen : public Thermostat
{
public:
  Berendsen(double);
  virtual ~Berendsen();

  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::list) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::vector) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::set) atoms);

  virtual std::string name();

  virtual std::string writeParam();

private:
  template <class ForwardIterator>
  double doScaleAtoms(unsigned int step,double ActualTemp,ForwardIterator begin, ForwardIterator end);

  double TempFrequency;
};

template <>
struct ThermostatTraits<class Berendsen> : public ThermostatTraits<Thermostat>
{
  ThermostatTraits();
  const char* name;
};

#endif /* BERENDSEN_HPP_ */
