/*
 * SurfaceCorrelationAction.hpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#ifndef SURFACECORRELATIONACTION_HPP_
#define SURFACECORRELATIONACTION_HPP_

#include "Actions/Action.hpp"
#include <string>
#include <vector>

class element;
class molecule;

void AnalysisSurfaceCorrelation(std::vector< element *> &elements, molecule *mol, double BinStart, double BinWidth, double BinEnd, std::string &outputname, std::string &binoutputname, bool periodic);

class AnalysisSurfaceCorrelationAction : public Action {
  friend void AnalysisSurfaceCorrelation(std::vector< element *> &elements, molecule *mol, double BinStart, double BinWidth, double BinEnd, std::string &outputname, std::string &binoutputname, bool periodic);
public:
  AnalysisSurfaceCorrelationAction();
  virtual ~AnalysisSurfaceCorrelationAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog*);
private:
  virtual void getParametersfromValueStorage();
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};

#endif /* SURFACECORRELATIONACTION_HPP_ */
