/*
 * PointCorrelationAction.hpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#ifndef POINTCORRELATIONACTION_HPP_
#define POINTCORRELATIONACTION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Actions/Action.hpp"
#include "LinearAlgebra/Vector.hpp"
#include <vector>
#include <string>

class element;

void AnalysisPointCorrelation(std::vector< element *> &elements, Vector &position, double BinStart, double BinWidth, double BinEnd, std::string &outputname, std::string &binoutputname, bool periodic);

class AnalysisPointCorrelationAction : public Action {
  friend void AnalysisPointCorrelation(std::vector< element *> &elements, Vector &position, double BinStart, double BinWidth, double BinEnd, std::string &outputname, std::string &binoutputname, bool periodic);

public:
  AnalysisPointCorrelationAction();
  virtual ~AnalysisPointCorrelationAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog*);
private:
  virtual void getParametersfromValueStorage();
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};

#endif /* POINTCORRELATIONACTION_HPP_ */
