/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2015 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * KeyValuePairCommandLineQuery.cpp
 *
 *  Created on: May 16, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "Actions/Values.hpp"
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include "Parameters/Specifics/KeyValuePair.hpp"

CommandLineDialog::KeyValuePairCommandLineQuery::KeyValuePairCommandLineQuery(Parameter<KeyValuePair> &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<KeyValuePair>(_param, _title, _description)
{}

CommandLineDialog::KeyValuePairCommandLineQuery::~KeyValuePairCommandLineQuery() {}

void CommandLineDialog::KeyValuePairCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    try {
      temp = CommandLineParser::getInstance().vm[getTitle()].as< KeyValuePair >();
    } catch(boost::bad_any_cast &e) {
      temp = KeyValuePair(std::string(""));
      return;
    }
    handleSuccess = true; return;
  }
}

