/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * TextWindow.cpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>
#include <boost/shared_ptr.hpp>

#include "Menu/TextMenu/TextMenu.hpp"
#include "Menu/TextMenu/TxMenu.hpp"
#include "Menu/TextMenu/ActionMenuItem.hpp"
#include "Menu/TextMenu/SeparatorMenuItem.hpp"
#include "Menu/TextMenu/DisplayMenuItem.hpp"
#include "Menu/TextMenu/SubMenuItem.hpp"
#include "TextUI/TextStatusIndicator.hpp"
#include "TextUI/TextWindow.hpp"
#include "Actions/MethodAction.hpp"
#include "Actions/ErrorAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/ActionTrait.hpp"
#include "Parser/ChangeTracker.hpp"
#include "Views/StreamStringView.hpp"
#include "Views/MethodStringView.hpp"

#include "Helpers/defs.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

// needed due to Enumerate()
#include "MoleculeListClass.hpp"

#include <iostream>
#include <map>

using namespace MoleCuilder;

// TODO: see what code can be moved to a base class for Graphic and Text Windows
TextWindow::TextWindow()
{
  // build the main menu
  main_menu = new TextMenu<TxMenu>(std::cout, "");
  // reserve s for save and q for quite
  main_menu->reserveShortcut('s', "output");
  main_menu->reserveShortcut('q', "quit");

  moleculeView = new StreamStringView(boost::bind(&MoleculeListClass::Enumerate,World::getInstance().getMolecules(),_1));
  new DisplayMenuItem(main_menu->getMenuInstance(),moleculeView,"Molecule List");

  new SeparatorMenuItem(main_menu->getMenuInstance());

  main_menu->init();

  new SeparatorMenuItem(main_menu->getMenuInstance());

  // save has reserved key 's'
//  Action *saveConfigAction = ActionRegistry::getInstance().getActionByName("output");
  new ActionMenuItem('s',"save current setup to config files",main_menu->getMenuInstance(),"output");

  // create a specific quit action for this UI and store in registry
  ActionTrait quitTrait(OptionTrait("quit", &typeid(void), "quits the program"));
  quitAction = new MethodAction(quitTrait,boost::bind(&TxMenu::doQuit,main_menu->getMenuInstance()),true);
  new ActionMenuItem('q',"quit",main_menu->getMenuInstance(),"quit");

  // Add status indicators etc...
  statusIndicator = new TextStatusIndicator();
}

TextWindow::~TextWindow()
{
  for (std::list<Action *>::iterator iter = returnFromActions.begin();
      !returnFromActions.empty();
      iter = returnFromActions.begin()) {
    delete (*iter);
    returnFromActions.erase(iter);
  }
  delete moleculeView;
  delete statusIndicator;
  delete main_menu;
}

void TextWindow::display() {
  main_menu->display();
}

