/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * TextUIFactory.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/TextUI/TextUIFactory.hpp"
#include "UIElements/TextUI/TextWindow.hpp"
#include "UIElements/TextUI/TextDialog.hpp"

TextUIFactory::TextUIFactory()
{}

TextUIFactory::~TextUIFactory()
{}


Dialog* TextUIFactory::makeDialog() {
  return new TextDialog();
}

MainWindow* TextUIFactory::makeMainWindow() {
  return new TextWindow();
}

TextUIFactory::description::description() :
    UIFactory::factoryDescription("Text")
{}

TextUIFactory::description::~description()
{}

UIFactory* TextUIFactory::description::makeFactory(){
  return new TextUIFactory();
}

