/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <Descriptors/AtomDescriptor.hpp>
#include <Descriptors/AtomIdDescriptor.hpp>
#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include "Atom/atom.hpp"
#include "World.hpp"


TextDialog::AtomsTextQuery::AtomsTextQuery(string title, std::string _description) :
    Dialog::AtomsQuery(title,_description)
{}

TextDialog::AtomsTextQuery::~AtomsTextQuery() {}

bool TextDialog::AtomsTextQuery::handle() {
  int idxOfAtom=-1;
  std::cout << getDescription() << ": ";
  std::string line;
  getline(std::cin,line);
  // dissect by " "
  std::string::iterator olditer = line.begin();
  for(string::iterator iter = line.begin(); iter != line.end(); ++iter) {
    if (*iter == ' ') {
      std::istringstream stream(string(iter, olditer));
      stream >> idxOfAtom;
      temp = World::getInstance().getAtom(AtomById(idxOfAtom));
      if(!temp && idxOfAtom!=-1){
        std::cout << "Invalid Atom Index" << idxOfAtom << std::endl;
        break;
      }
      tmp.push_back(temp);
      olditer = iter;
    }
  }
  if (olditer != line.begin()) { // insert last part also
    std::istringstream stream(string(olditer, line.end()));
    stream >> idxOfAtom;
    temp = World::getInstance().getAtom(AtomById(idxOfAtom));
    if(!temp && idxOfAtom!=-1) {
      std::cout << "Invalid Atom Index" << idxOfAtom << std::endl;
      tmp.push_back(temp);
    }
  }

  return (idxOfAtom!=-1);
}

