/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Thermostat.cpp
 *
 *  Created on: Aug 18, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Thermostat.hpp"

#include "CodePatterns/Assert.hpp"

Thermostat::Thermostat() :
  container(0)
{}

Thermostat::~Thermostat()
{}

const char *ThermostatTraits<Thermostat>::name = "Base";

std::string ThermostatTraits<Thermostat>::getName(){
  return ThermostatTraits<Thermostat>::name;
}

void Thermostat::addToContainer(ThermoStatContainer *_container){
  container = _container;
}

ThermoStatContainer &Thermostat::getContainer(){
  ASSERT(container,"No container used for this Thermostat");
  return *container;
}
