/*
 * TesselationHelpers.hpp
 *
 *  Auxiliary functions for the tesselation.
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef TESSELATIONHELPERS_HPP_
#define TESSELATIONHELPERS_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>

#include "defs.hpp"

/****************************************** forward declarations *****************************/

class BoundaryPointSet;
class BoundaryLineSet;
class BoundaryTriangleSet;
class LinkedCell;
class TesselPoint;
class PointCloud;
class Tesselation;
class Vector;

/********************************************** definitions *********************************/

#define HULLEPSILON 1e-9 //!< TODO: Get rid of HULLEPSILON, points to numerical instabilities

/********************************************** declarations *******************************/

void GetSphere(Vector * const Center, const Vector &a, const Vector &b, const Vector &c, const double RADIUS);
void GetCenterOfSphere(Vector* const Center, const Vector &a, const Vector &b, const Vector &c, Vector * const NewUmkreismittelpunkt, const Vector* const Direction, const Vector* const AlternativeDirection, const double HalfplaneIndicator, const double AlternativeIndicator, const double alpha, const double beta, const double gamma, const double RADIUS, const double Umkreisradius);
void GetCenterofCircumcircle(Vector * const Center, const Vector &a, const Vector &b, const Vector &c);
double GetPathLengthonCircumCircle(const Vector &CircleCenter, const Vector &CirclePlaneNormal, const double CircleRadius, const Vector &NewSphereCenter, const Vector &OldSphereCenter, const Vector &NormalVector, const Vector &SearchDirection);
double CalculateVolumeofGeneralTetraeder(const Vector &a, const Vector &b, const Vector &c, const Vector &d);
double CalculateAreaofGeneralTriangle(const Vector &A, const Vector &B, const Vector &C);
double GetAngle(const Vector &point, const Vector &reference, const Vector &OrthogonalVector);

bool CheckLineCriteriaForDegeneratedTriangle(const BoundaryPointSet * const nodes[3]);
bool SortCandidates(const CandidateForTesselation* candidate1, const CandidateForTesselation *candidate2);
TesselPoint* FindClosestTesselPoint(const Vector* Point, TesselPoint *&SecondPoint, const LinkedCell* const LC);
TesselPoint* FindSecondClosestTesselPoint(const Vector*, const LinkedCell* const LC);
Vector * GetClosestPointBetweenLine(const BoundaryLineSet * const Base, const BoundaryLineSet * const OtherBase);

void WriteTecplotFile(ofstream * const tecplot, const Tesselation * const TesselStruct, const PointCloud * const cloud, const int N);
void WriteRaster3dFile(ofstream * const rasterfile, const Tesselation * const Tess, const PointCloud * const cloud);
void IncludeSphereinRaster3D(ofstream * const rasterfile, const Tesselation *Tess, const PointCloud *cloud);
void WriteVrmlFile(ofstream * const vrmlfile, const Tesselation * const Tess, const PointCloud * const cloud);
void CalculateConcavityPerBoundaryPoint(const Tesselation * const TesselStruct);
void CalculateConstrictionPerBoundaryPoint(const Tesselation * const TesselStruct, const Tesselation * const Convex);
double DistanceToTrianglePlane(const Vector *x, const BoundaryTriangleSet * const triangle);

bool CheckListOfBaselines(const Tesselation * const TesselStruct);

int CountTrianglePairContainingPolygon(const BoundaryPolygonSet * const P, const TriangleSet * const T);
bool ArePolygonsEdgeConnected(const BoundaryPolygonSet * const P1, const BoundaryPolygonSet * const P2);
void CombinePolygons(BoundaryPolygonSet * const P1, BoundaryPolygonSet * &P2);


#endif /* TESSELATIONHELPERS_HPP_ */
