/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * logger.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <fstream>
#include <iostream>
#include "Helpers/logger.hpp"
#include "Helpers/Verbose.hpp"
#include "Patterns/Singleton_impl.hpp"


int logger::verbosity = 2;
ostream* logger::nix = NULL;

/**
 * Constructor. Do not use this function. Use getInstance() instead.
 *
 * \return logger instance
 */
logger::logger()
{
  nix = new ofstream("/dev/null");
};

/**
 * Destructor. Better use purgeInstance().
 */
logger::~logger()
{
  delete nix;
}

CONSTRUCT_SINGLETON(logger)

/**
 * Sets the verbosity.
 *
 * \param verbosityLevel verbosity
 */
void logger::setVerbosity(int verbosityLevel) {
  verbosity = verbosityLevel;
}

/**
 * Gets the verbosity.
 *
 * \return verbosity level
 */
int logger::getVerbosity()
{
  return verbosity;
}

/**
 * Operator for the Binary(arg) call.
 * Constructs temporary a Verbose class object, wherein the Binary is stored.
 * Then << is called, which calls Binary's print which adds the tabs and logs
 * the stream.
 * \param &ost stream to extend
 * \param &m pointer to created Binary object
 * \return &ost
 */
ostream& operator<<(class logger& l, const Verbose& v)
{
  int verbosityLevel = l.verbosity;
  l.nix->clear();
  if (v.DoOutput(verbosityLevel)) {
    v.print(cout);
    return cout;
  } else
    return *l.nix;
};
ostream& operator<<(class logger* l, const Verbose& v)
{
  int verbosityLevel = l->verbosity;
  l->nix->clear();
  if (v.DoOutput(verbosityLevel)) {
    v.print(cout);
    return cout;
  } else
    return *l->nix;
};

