/*
 * LoadXyzAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

using namespace std;

#include "Actions/ParserAction/LoadXyzAction.hpp"
#include "Parser/XyzParser.hpp"

#include <iostream>
#include <set>
#include <string>
#include <vector>


#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

#include "atom.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** ParserLoadXyzAction *****/

//// memento to remember the state when undoing
//
//class ParserLoadXyzState : public ActionState {
//public:
//  ParserLoadXyzState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char ParserLoadXyzAction::NAME[] = "parse-xyz";

ParserLoadXyzAction::ParserLoadXyzAction() :
  Action(NAME)
{}

ParserLoadXyzAction::~ParserLoadXyzAction()
{}

Dialog* ParserLoadXyzAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr ParserLoadXyzAction::performCall() {
  string filename;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);

  DoLog(1) && (Log() << Verbose(1) << "Parsing xyz file for new atoms." << endl);
  // parse xyz file
  ifstream input;
  input.open(filename.c_str());
  if (!input.fail()) {
    // TODO: Remove the insertion into molecule when saving does not depend on them anymore. Also, remove molecule.hpp include
    set <atom*> UniqueList;
    {
      vector<atom *> ListBefore = World::getInstance().getAllAtoms();
      for (vector<atom *>::iterator runner = ListBefore.begin();runner != ListBefore.end(); ++runner)
        UniqueList.insert(*runner);
    }
    XyzParser parser; // briefly instantiate a parser which is removed at end of focus
    parser.load(&input);
    {
      vector<atom *> ListAfter = World::getInstance().getAllAtoms();
      pair< set<atom *>::iterator, bool > Inserter;
      if (UniqueList.size() != ListAfter.size()) { // only create if new atoms have been parsed
        MoleculeListClass *molecules = World::getInstance().getMolecules();
        molecule *mol = World::getInstance().createMolecule();
        molecules->insert(mol);
        for (vector<atom *>::iterator runner = ListAfter.begin(); runner != ListAfter.end(); ++runner) {
          Inserter = UniqueList.insert(*runner);
          if (Inserter.second) { // if not present, then new (just parsed) atom, add ...
            cout << "Adding new atom " << **runner << " to new mol." << endl;
            mol->AddAtom(*runner);
          }
        }
        mol->doCountAtoms();
      } else {
        cout << "No atoms parsed?" << endl;
      }
    }
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "Could not open file " << filename << "." << endl);
  }
  input.close();
  return Action::success;
}

Action::state_ptr ParserLoadXyzAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr ParserLoadXyzAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool ParserLoadXyzAction::canUndo() {
  return false;
}

bool ParserLoadXyzAction::shouldUndo() {
  return false;
}

const string ParserLoadXyzAction::getName() {
  return NAME;
}
