/*
 * TextDialog.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef TEXTDIALOG_HPP_
#define TEXTDIALOG_HPP_

#include <string>

#include "UIElements/Dialog.hpp"

class TextDialog : public Dialog
{
public:
  TextDialog();
  virtual ~TextDialog();

  virtual void queryInt(const char *, int *, std::string = "");
  virtual void queryString(const char*, std::string *, std::string = "");
  virtual void queryDouble(const char*, double*, std::string = "");
  virtual void queryMolecule(const char*,molecule**,MoleculeListClass*, std::string = "");
  virtual void queryVector(const char*,Vector *,const double * const,bool, std::string = "");
  virtual void queryElement(const char*,const element **, std::string = "");

protected:
  // specialized stuff for text queries
  class IntTextQuery : public Dialog::IntQuery {
  public:
    IntTextQuery(std::string title, int *_target, std::string _description = NULL);
    virtual ~IntTextQuery();
    virtual bool handle();
  };

  class DoubleTextQuery : public Dialog::DoubleQuery {
  public:
    DoubleTextQuery(std::string title, double *_target, std::string _description = NULL);
    virtual ~DoubleTextQuery();
    virtual bool handle();
  };

  class StringTextQuery : public Dialog::StringQuery {
  public:
    StringTextQuery(std::string title, std::string *_target, std::string _description = NULL);
    virtual ~StringTextQuery();
    virtual bool handle();
  };

  class MoleculeTextQuery : public Dialog::MoleculeQuery {
  public:
    MoleculeTextQuery(std::string title, molecule **_target, MoleculeListClass *_molecules, std::string _description = NULL);
    virtual ~MoleculeTextQuery();
    virtual bool handle();
  };

  class VectorTextQuery : public Dialog::VectorQuery {
  public:
    VectorTextQuery(std::string title,Vector *_target,const double *const _cellSize,bool _check, std::string _description = NULL);
    virtual ~VectorTextQuery();
    virtual bool handle();
  };

  class ElementTextQuery : public Dialog::ElementQuery {
  public:
    ElementTextQuery(std::string title, const element **_target, std::string _description = NULL);
    virtual ~ElementTextQuery();
    virtual bool handle();
  };
};

#endif /* TEXTDIALOG_HPP_ */
