/*
 * Dialog.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#include <cassert>

#include "UIElements/Dialog.hpp"

#include "vector.hpp"

using namespace std;

Dialog::Dialog()
{
}

Dialog::~Dialog()
{
  list<Query*>::iterator iter;
  for(iter=queries.begin();iter!=queries.end();iter++){
    delete (*iter);
  }
}

void Dialog::registerQuery(Query *query){
  queries.push_back(query);
}

bool Dialog::display(){
  list<Query*>::iterator iter;
  bool retval = true;
  for(iter=queries.begin(); iter!=queries.end(); iter++){
    retval &= (*iter)->handle();
    // if any query fails (is canceled), we can end the handling process
    if(!retval)
      break;
  }
  if (retval){
    // if all queries succeeded we can set the targets to appropriate values
    for(iter=queries.begin(); iter!=queries.end(); iter++) {
      (*iter)->setResult();
    }
  }
  return retval;
}

/****************** Query types Infrastructure **************************/

// Base class
Dialog::Query::Query(string _title, string _description) :
    title(_title),
    description(_description)
{}

Dialog::Query::~Query() {}

const std::string Dialog::Query::getTitle() const{
  return title;
}

const std::string Dialog::Query::getDescription() const{
  return description;
}
// Int Queries

Dialog::IntQuery::IntQuery(string title,int *_target, std::string description) :
    Query(title, description), target(_target)
{}

Dialog::IntQuery::~IntQuery() {}

void Dialog::IntQuery::setResult() {
  *target = tmp;
}

// String Queries

Dialog::StringQuery::StringQuery(string title,string *_target, std::string _description) :
    Query(title, _description), target(_target)
{}

Dialog::StringQuery::~StringQuery() {};

void Dialog::StringQuery::setResult() {
  *target = tmp;
}

// Double Queries

Dialog::DoubleQuery::DoubleQuery(string title,double *_target, std::string _description) :
    Query(title, _description), target(_target)
{}

Dialog::DoubleQuery::~DoubleQuery() {};

void Dialog::DoubleQuery::setResult() {
  *target = tmp;
}


// Molecule Queries

Dialog::MoleculeQuery::MoleculeQuery(string title, molecule **_target, MoleculeListClass *_molecules, std::string _description) :
    Query(title, _description),
    tmp(0),
    molecules(_molecules),
    target(_target)

{}

Dialog::MoleculeQuery::~MoleculeQuery() {}

void Dialog::MoleculeQuery::setResult() {
  *target = tmp;
}

// Vector Queries

Dialog::VectorQuery::VectorQuery(std::string title,Vector *_target,const double *const _cellSize,bool _check, std::string _description) :
  Query(title, _description),
  cellSize(_cellSize),
  check(_check),
  target(_target)
{
tmp = new Vector();
}

Dialog::VectorQuery::~VectorQuery()
{
  delete tmp;
}

void Dialog::VectorQuery::setResult() {
  *target = *tmp;
}

// Element Queries
Dialog::ElementQuery::ElementQuery(std::string title, const element **_target, std::string _description) :
  Query(title, _description),
  tmp(0),
  target(_target)
  {}

Dialog::ElementQuery::~ElementQuery(){}

void Dialog::ElementQuery::setResult(){
  *target=tmp;
}
